Unit FriendClass;

Interface

Uses Sysutils, math;

Type
  TFriend = Class(TObject)
  Private
    fullName: String;
    cellNumber: String;
    birthDate: TDateTime;
    lastseen: TDateTime;
    category: string;
  Protected

  Public
    Constructor Create; Overload;
    Constructor Create(fullName, cellNumber: String;
      birthDate, lastseen: TDateTime; category: string); Overload;
    Function findAge: integer;
    Function getLastseen: TDateTime;
    Function getFullName: String;
    Function getCellNumber: String;
    Function getBirthdate: TDateTime;
    Function getCategory: string;
    Procedure setLastseen(lastseen: TDateTime);
    Function ToString: String;
  End;

Implementation

{ TFriend }

Constructor TFriend.Create;
Begin
  { default }
End;

Constructor TFriend.Create(fullName, cellNumber: String;
  birthDate, lastseen: TDateTime; category: string);
Begin
  self.fullName := fullName;
  self.cellNumber := cellNumber;
  self.birthDate := birthDate;
  self.lastseen := lastseen;
  self.category := category;
End;

Function TFriend.findAge: integer;
Var
  daysOld: integer;
Begin
  daysOld := round(now - birthDate);
  findAge := daysOld Div 365;
End;

function TFriend.getBirthdate: TDateTime;
begin
   Result:= self.birthDate;
end;

function TFriend.getCategory: string;
begin
    Result:= self.category;
end;

function TFriend.getCellNumber: String;
begin
   Result:= self.cellNumber;
end;

function TFriend.getFullName: String;
begin
Result:=Self.fullName;
end;

Function TFriend.getLastseen: TDateTime;
Begin
  getLastseen := lastseen;
End;

Procedure TFriend.setLastseen(lastseen: TDateTime);
Begin
  self.lastseen := lastseen;
End;

Function TFriend.ToString: String;
Begin
  result := Format(' Name: %s%s cellNumber: %s%s birthDate: %s%s'
  + 'lastseen: %s%s category: %s%s',
     [fullName,sLineBreak,  cellNumber, sLineBreak, datetoStr(birthDate),sLineBreak,
      datetostr(lastseen),sLineBreak,  category, sLineBreak] );
End;

End.
